/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfResult;
import com.ibm.hwmca.fw.rbf.impl.QueryTask;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RequestTrackingData
implements Persistable {
    Set handlerSubset = null;
    int state = 0;
    Date submitDate = null;
    MachineId origin = null;
    List history = null;
    Set askingToPrepare = null;
    Set preparing = null;
    Set busy = null;
    Set aborting = null;
    boolean notCapableOffer = false;
    RbfErrorDetail errorDetail = null;
    int errorResultCode = 0;
    Set unusable = null;
    MachineId handler = null;
    boolean redrive = false;
    boolean canceled = false;
    boolean handlerOutage = false;
    boolean handlerCopy = false;
    Object offerLock = new Object();
    QueryTask queryTask = null;
    RbfResult result = null;

    public RequestTrackingData() {
    }

    public RequestTrackingData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        int rbfVersion = persistent.rbfVersion;
        this.handlerSubset = persistent.handlerSubset;
        this.state = persistent.state;
        this.submitDate = persistent.submitDate;
        this.origin = persistent.origin;
        this.history = persistent.history;
        this.handler = persistent.handler;
        this.unusable = persistent.unusable;
        this.redrive = persistent.redrive;
        this.canceled = persistent.canceled;
        this.handlerOutage = persistent.handlerOutage;
        this.handlerCopy = persistent.handlerCopy;
        this.result = persistent.result == null ? null : new RbfResult(persistent.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            persistent.rbfVersion = 2;
            persistent.handlerSubset = this.handlerSubset;
            persistent.state = this.state;
            persistent.submitDate = this.submitDate;
            persistent.origin = this.origin;
            persistent.history = this.history;
            persistent.handler = this.handler;
            persistent.unusable = this.unusable;
            persistent.redrive = this.redrive;
            persistent.canceled = this.canceled;
            persistent.handlerOutage = this.handlerOutage;
            persistent.handlerCopy = this.handlerCopy;
            persistent.result = this.result == null ? null : this.result.getPersistentData();
        }
        return persistent;
    }

    public boolean isUpgradeData() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandlerSubset(Set handlerSubset) {
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            this.handlerSubset = handlerSubset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getHandlerSubset() {
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            if (this.handlerSubset == null) {
                return null;
            }
            return new HashSet(this.handlerSubset);
        }
    }

    public int getState() {
        return this.state;
    }

    boolean isStateValid(int state) {
        switch (state) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
            case 16: {
                return true;
            }
            case 20: {
                return true;
            }
        }
        return false;
    }

    boolean isStateChangeValid(int from, int to) {
        if (!this.isStateValid(from) || !this.isStateValid(to) || from == to) {
            return false;
        }
        switch (from) {
            case 0: {
                return to == 4;
            }
            case 4: {
                if (to == 6) {
                    return true;
                }
                if (to == 8) {
                    return true;
                }
                if (to == 12) {
                    return true;
                }
                return to == 16;
            }
            case 8: {
                if (to == 6) {
                    return true;
                }
                if (to == 12) {
                    return true;
                }
                return to == 16;
            }
            case 6: {
                if (to == 12) {
                    return true;
                }
                return to == 20;
            }
            case 12: {
                return to == 16;
            }
            case 16: {
                return to == 20;
            }
            case 20: {
                return false;
            }
        }
        return false;
    }

    void setSubmitDate(Date date) {
        this.submitDate = date;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public MachineId getOrigin() {
        return this.origin;
    }

    void setHandler(MachineId machine) {
        this.handler = machine;
        this.addHistory("Handler " + RbfUtils.getMachineInfo(machine));
    }

    public MachineId getHandler() {
        return this.handler;
    }

    boolean isHandlerNeeded() {
        if (this.state == 4) {
            if (this.handler == null) {
                return true;
            }
            return this.handler != null && this.handlerOutage;
        }
        if (this.state == 8) {
            return this.handlerOutage || this.redrive;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHistory(String entry) {
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            if (this.history == null) {
                this.history = new ArrayList();
            }
            this.history.add(new Date() + "  " + entry);
        }
    }

    void addAskingToPrepare(MachineId machine) {
        if (this.askingToPrepare == null) {
            this.askingToPrepare = new HashSet();
        }
        if (this.askingToPrepare.add(machine)) {
            this.addHistory("Asking to prepare " + RbfUtils.getMachineInfo(machine));
        }
    }

    boolean removeAskingToPrepare(MachineId machine) {
        if (this.askingToPrepare == null) {
            return false;
        }
        return this.askingToPrepare.remove(machine);
    }

    void addPreparing(MachineId machine) {
        if (this.preparing == null) {
            this.preparing = new HashSet();
        }
        if (this.preparing.add(machine)) {
            this.addHistory("Preparing " + RbfUtils.getMachineInfo(machine));
        }
    }

    boolean removePreparing(MachineId machine) {
        if (this.preparing == null) {
            return false;
        }
        return this.preparing.remove(machine);
    }

    boolean isPreparing(MachineId machine) {
        if (this.preparing == null) {
            return false;
        }
        return this.preparing.contains(machine);
    }

    void addBusy(MachineId machine) {
        if (this.busy == null) {
            this.busy = new HashSet();
        }
        if (this.busy.add(machine)) {
            this.addHistory("Busy " + RbfUtils.getMachineInfo(machine));
        }
    }

    void removeAllBusy() {
        if (this.busy != null) {
            this.busy.clear();
        }
    }

    boolean isAnyBusy() {
        return this.busy != null && !this.busy.isEmpty();
    }

    void addAborting(MachineId machine) {
        if (this.aborting == null) {
            this.aborting = new HashSet();
        }
        if (this.aborting.add(machine)) {
            this.addHistory("Aborting " + RbfUtils.getMachineInfo(machine));
        }
    }

    void addAborting(Collection machines) {
        if (this.aborting == null) {
            this.aborting = new HashSet();
        }
        if (this.aborting.addAll(machines)) {
            this.addHistory("Aborting " + RbfUtils.getMachineInfo(machines));
        }
    }

    boolean removeAborting(MachineId machine) {
        if (this.aborting == null) {
            return false;
        }
        return this.aborting.remove(machine);
    }

    boolean isAborting(MachineId machine) {
        if (this.aborting == null) {
            return false;
        }
        return this.aborting.contains(machine);
    }

    boolean isAnyAborting() {
        return this.aborting != null && !this.aborting.isEmpty();
    }

    void addUnusable(MachineId machine) {
        if (this.unusable == null) {
            this.unusable = new HashSet();
        }
        if (this.unusable.add(machine)) {
            this.addHistory("Unusable " + RbfUtils.getMachineInfo(machine));
        }
    }

    boolean removeUnusable(MachineId machine) {
        if (this.unusable == null) {
            return false;
        }
        return this.unusable.remove(machine);
    }

    boolean isUnusable(MachineId machine) {
        if (this.unusable == null) {
            return false;
        }
        return this.unusable.contains(machine);
    }

    boolean isAnyPreparation() {
        if (this.askingToPrepare != null && !this.askingToPrepare.isEmpty()) {
            return true;
        }
        return this.preparing != null && !this.preparing.isEmpty();
    }

    public boolean isHandlerCopy() {
        return this.handlerCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryDump() {
        StringBuffer sb = new StringBuffer();
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            if (this.history == null) {
                sb.append("No history available");
            } else {
                Iterator entries = this.history.iterator();
                while (entries.hasNext()) {
                    String entry = (String)entries.next();
                    sb.append(entry);
                    if (!entries.hasNext()) continue;
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        RequestTrackingData requestTrackingData = this;
        synchronized (requestTrackingData) {
            sb.append("[RequestTrackingData:\n");
            sb.append("handlerSubset=" + RbfUtils.getMachineInfo(this.handlerSubset) + "\n");
            sb.append("state=" + this.state + "\n");
            sb.append("submitted=" + this.submitDate + "\n");
            if (this.origin != null) {
                sb.append("origin=" + RbfUtils.getMachineInfo(this.origin) + "\n");
            } else {
                sb.append("origin=null\n");
            }
            sb.append("askingToPrepare=" + RbfUtils.getMachineInfo(this.askingToPrepare) + "\n");
            sb.append("preparing=" + RbfUtils.getMachineInfo(this.preparing) + "\n");
            sb.append("busy=" + RbfUtils.getMachineInfo(this.busy) + "\n");
            sb.append("aborting=" + RbfUtils.getMachineInfo(this.aborting) + "\n");
            sb.append("unusable=" + RbfUtils.getMachineInfo(this.unusable) + "\n");
            if (this.handler != null) {
                sb.append("handler=" + RbfUtils.getMachineInfo(this.handler) + "\n");
            } else {
                sb.append("handler=null\n");
            }
            sb.append("redrive=" + this.redrive + "\n");
            sb.append("canceled=" + this.canceled + "\n");
            sb.append("handlerOutage=" + this.handlerOutage + "\n");
            sb.append("handlerCopy=" + this.handlerCopy + "\n");
            if (this.queryTask != null) {
                sb.append("queryTask=yes \n");
            } else {
                sb.append("queryTask=null \n");
            }
            if (this.errorDetail != null) {
                sb.append("errorDetail=yes \n");
            } else {
                sb.append("errorDetail=null \n");
            }
            if (this.result != null) {
                sb.append("result=yes]");
            } else {
                sb.append("result=null]");
            }
        }
        return sb.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -1396057389792246094L;
        int rbfVersion;
        Set handlerSubset;
        int state;
        Date submitDate;
        MachineId origin;
        List history;
        MachineId handler;
        Set unusable;
        boolean redrive;
        boolean canceled;
        boolean handlerOutage;
        boolean handlerCopy;
        PersistentData result;

        private Persistent() {
        }
    }
}

